#include <iostream>
#include <algorithm>
#include <vector>

void findXYZ(int x, int y, int z) {
    // Check if the given combination satisfies the conditions
    if (x <= y && y <= z) {
        std::cout << "X: " << x << std::endl;
        std::cout << "Y: " << y << std::endl;
        std::cout << "Z: " << z << std::endl;
    }
    return 0;
}

int main() {
    std::vector<int> values(7);

    // Read input values
    std::cout << "Enter seven integers (X, Y, Z, X+Z, X+Y, Y+Z, X+Y+Z): ";
    for (int i = 0; i < 7; ++i) {
        std::cin >> values[i];
    }

    // Iterate over all permutations to find X, Y, Z
    std::sort(values.begin(), values.end());
    do {
        int x = values[0];
        int y = values[1];
        int z = values[2];
        int xz = values[3];
        int xy = values[4];
        int yz = values[5];
        int xyz = values[6];

        // Check if the given combination satisfies the conditions
        if (xz == x + z && xy == x + y && yz == y + z && xyz == x + y + z) {
            findXYZ(x, y, z);
            return 0;
        }
    } while (std::next_permutation(values.begin(), values.end()));

    std::cout << "No valid X, Y, Z found." << std::endl;

    return 0;
}